//precision highp float;

uniform float u_heatStrength;
uniform float u_phaseHeat;
uniform float u_temperature;

uniform float u_heatScale;
uniform vec2 u_uvSize;
varying vec2 v_texCoord;
varying vec2 v_diffTexCoord;

void main()
{
    
    vec4 dispCol= vec4(0.0);
    vec2 coord = vec2(0.0);
    vec2 noiseUV = vec2(0.0);
    vec2 noiseHeat = vec2(0.0);
    
    float scale;
    //Heat haze
    
    scale = u_temperature;
    noiseUV = mod(v_texCoord * u_heatScale * scale + vec2(u_phaseHeat,0.0), 1.0);
    noiseHeat = texture2D(CC_Texture2, noiseUV).xy;
    noiseHeat = noiseHeat - 0.5;
    noiseHeat *= u_heatStrength * step(0.1, scale);
    
    coord =clamp(v_diffTexCoord + noiseHeat , vec2(0.0) , 0.999 * u_uvSize);
    dispCol = texture2D(CC_Texture1, coord) ;
    
    gl_FragColor = dispCol;
}
